//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: example of pulse width measurement mode of TCA0
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6822_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6822.h"
 
#define TEST_Signal_Width_L 0x34
#define TEST_Signal_Width_H 0x01
#define TEST_Signal_Period_L 0x34
#define TEST_Signal_Period_H 0x02



unsigned int PULSE_WIDTH;
unsigned int PERIOD_WIDTH;
void main()
{
      
	  CGCR.byte=0x02;	//fcgck = fc/4 = 4Mhz
	  
	  
	P8FC.bit.b2 = 1;	
	P8CR.bit.b2 = 1;	//set PPG4 for test signal
	P7CR.bit.b2 = 0;	//TCA0 input

	__asm("DI");
	POFFCR0.byte = 0x41;
	EIRH.bit.b6 = 1;
	__asm("EI");
	//=================
	// set PPG input signal
	// for testing Pulse width Measurement Mode
	// 
	// ================

	T04MOD.byte = 0x72;	//TFF =0,double buffer,sck = fcgck/2,10-bit PWM mode
	T04PWML.byte = TEST_Signal_Width_L;
	T04PWMH.byte = TEST_Signal_Width_H;
	T04REGL.byte = TEST_Signal_Period_L;
	T04REGH.byte = TEST_Signal_Period_H;
	
	//=================
	// set Pulse width Measurement Mode
	// 
	// 
	// ================
	TA0CR.byte = 0xc0;	//enable Overflow interrupt,TFF=1,no noise canceller
						
	TA0MOD.byte = 0xde;	//0x9e;	//double buffer,double edge capture,sck=fcgck/2,
						//Pulse width measurement mode

	//=================
	// start Pulse width Measurement Mode
	// ================
	TA0CR.bit.b0= 1;
	//=================
	// start PPG 
	// ================
	T045CR.bit.b0 = 1;
	while(1)
	{
	//=============================================
	//handling the measurement value in void __interrupt IntA0(void)
	//==============================================
	 WDCDR.byte = 0x4e;	//clear WDT
	}
	
}